// GroupStruct.h: interface for the GroupStruct class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GROUPSTRUCT_H__F5F699B4_4A47_4A16_81A8_B6752330A898__INCLUDED_)
#define AFX_GROUPSTRUCT_H__F5F699B4_4A47_4A16_81A8_B6752330A898__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "StdObject.h"

class GroupStruct;
class StdObject;

typedef GroupStruct *GroupPtr;

enum GROUPTYPE {GroupSeperable,GroupNonSeperable};

class GroupStruct  
{

private:
	// Internal functionality that allows the groups to be selected and deselected
	void OnSelect1(GroupPtr tGroupPtr, const BOOL &toSelect);
	// to destroy group hierachy pointers
	void OnDestroy2(GroupPtr tPtr);
	void OnDestroy1(GroupPtr tPtr);
	void OnDestroy();

	public:
	GroupStruct* OnSelect(const BOOL &toSelect);


	GroupStruct();
	GroupStruct(StdObject *TheObject); // constructer used when a group point is created for an object
	virtual ~GroupStruct();

	StdObject *theObject; // the object in the group, note that every object has its base group

	GroupPtr Parent,Sibling,Child;
	int NumofObjects;
	int HierarchyLevel;
	int GroupNumber; // for saving groups via table


	GROUPTYPE GroupType;
	
						  

};

#endif // !defined(AFX_GROUPSTRUCT_H__F5F699B4_4A47_4A16_81A8_B6752330A898__INCLUDED_)
