// MDirectX.cpp: implementation of the MDirectX class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MapEditor.h"
#include "MDirectX.h"
#include "TerrainManager.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MDirectX::MDirectX()
{
/*	int ToolbarOffset = 26;

    WindowSize.left = 10;
    WindowSize.right = 510;
    WindowSize.top = 10 + ToolbarOffset;
    WindowSize.bottom = 510 + ToolbarOffset;   */

	GridDepth = 1;

	RCResetView();

}

MDirectX::~MDirectX()
{
//	 Cleanup3DEnvironment(); // base class cleanup

	 if (g_pGridVB != NULL)
         g_pGridVB->Release();

}

////////////////////////////////////////////////////////////
// void Create()
//
// Usage, called by the view window to initilize this class
//
//
void MDirectX::Create()
{
	// creates a new window and registers for it, to display the directX graphics
/*	char windowname[40]; 

    strcpy(windowname,AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		        ::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL));

    // Set the window's initial style
    m_dwWindowStyle = WS_THICKFRAME
                      |WS_VISIBLE| WS_CHILD ;

	
  


    // Create the render window 
    FrameWindow.CreateEx(WS_EX_TOPMOST  ,windowname,"Hello",m_dwWindowStyle,WindowSize,FramePtr,NULL,NULL);

    m_hWnd =FrameWindow.m_hWnd;
  
	// calls the base class
    CD3DApplication::Create( AfxGetInstanceHandle() );*/

	
	 if( FAILED( m_pd3dDevice->CreateVertexBuffer( MAXGRIDVERTEXCOUNT*sizeof(VERTEX),
												   D3DUSAGE_DYNAMIC ,
												   VERTEX_TYPE,
												   D3DPOOL_DEFAULT,
												   &g_pGridVB 
												   ) )) 
                                                   AfxMessageBox("Failed model Vertex Buffer");

}

////////////////////////////////////////////////////////////
// void OnRender()
//
// Usage, called by the view window when repainting
//
//
void MDirectX::OnRender()
{
//	Render3DEnvironment(); // tells the base class to start the rendering process
}

////////////////////////////////////////////////////////////
// void Create()
//
// Usage, overridded virtual function from the base class that actually does the 
// rendering
//
HRESULT MDirectX::Render()
{
//	if( SUCCEEDED( m_pd3dDevice->BeginScene() ) )
   // {

        // Clear the viewport
        if (m_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER ,
                           RGB(255,255,255), 1.0f, 0L ) != D3D_OK )
                           AfxMessageBox("Clear Problem");

		// identity for the world matrix
		D3DXMATRIX matrixWorld,t1,t2;
		D3DXMatrixIdentity(&matrixWorld);
	/*	t1 = matrixWorld;
		t2 = matrixWorld;
		D3DXMatrixRotationY(&t1,TheCamera.YAngle*PI/180.0f);
		D3DXMatrixRotationX(&t2,TheCamera.XAngle*PI/180.0f);
		matrixWorld = t1*t2;*/
		m_pd3dDevice->SetTransform( D3DTS_WORLD, &matrixWorld );

		AdjustCameraPosition(); // adjust the camera angle

		// View Transform
	    D3DXMATRIX matrixView;
		D3DXMatrixLookAtLH( &matrixView, 
							&TheCamera.Eye,	// Current camera position
                       		&TheCamera.At ,	// Look at position
							&TheCamera.Orientation) ;// Orientation 

	    m_pd3dDevice->SetTransform( D3DTS_VIEW, &matrixView );
		TheCamera.matrixView = matrixView; // store it for later use




	    // Projection Transform
	    D3DXMATRIX matProj;
		float Aspect = (float)WindowSize.Width()/(float)WindowSize.Height();
	    D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, Aspect, 0.001f, 10000.0f );
	    m_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj ); 
		TheCamera.matrixProj = matProj; // store it for later use

		LINEVERTEX* pVertices; // pointer for traversal of VB

		// lock the buffer
		if( SUCCEEDED( g_pGridVB->Lock(0, 0, (BYTE**)&pVertices, 0 ) ) )
		{
			int VertexCount;
			theOctTree.RenderOctGrid(pVertices,VertexCount,GridDepth);

			g_pGridVB->Unlock();

			m_pd3dDevice->SetTexture(0,NULL);
			
			//m_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);
		    m_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);
		//	m_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_POINT);
   
			m_pd3dDevice->SetStreamSource( 0, g_pGridVB, sizeof(LINEVERTEX) );
			m_pd3dDevice->SetVertexShader( LINEVERTEX_TYPE ); 

			m_pd3dDevice->SetRenderState( D3DRS_AMBIENT, 0xffffffff);
			m_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );

			int index = 0;
			if (VertexCount > 16000)
			{
				while (VertexCount > 16000)
				{
					HRESULT  tempp = m_pd3dDevice->DrawPrimitive( D3DPT_LINELIST, index, 16000);
					if (tempp == D3DERR_INVALIDCALL)
					{
						int asdf= 34;
					}
					index += 16000;
					VertexCount -= 16000;
				}				
			}
			m_pd3dDevice->DrawPrimitive( D3DPT_LINELIST, index, VertexCount);

		}

			// now render the objects
		theOctTree.RenderAllObjects(m_pd3dDevice);

		// now render the tiles
		theTerrainManager.RenderTiles1(m_pd3dDevice);

	//	m_pd3dDevice->EndScene();


//	}
//	D3DCAPS8 Caps;
	//m_pd3dDevice->GetDeviceCaps(&Caps);



	return S_OK;


}

/************************************************************************
* void AdjustCameraPosition()
*
* PURPOSE
* To increment the camera position if a camera movement key is depressed
* METHOD
* First takes a look at any mouse input such as panning or zooming, then it
* adjust the camera based on the current angles, again determined by user input
* USAGE
* Currently in the rendering loop
*************************************************************************/
void MDirectX::AdjustCameraPosition()
{
	float Movement = 0.1f; // constant to change movement speed


	float dx,dy,dz;		

	// check if there is any new mouse input to move the camera
	if (TheCamera.PanX != 0)
	{
		if (TheCamera.PanX < 0)
		{
			// pan right
			AdjustCameraPosition(dx,dy,dz,TheCamera.XAngle,TheCamera.YAngle+90,Movement*TheCamera.PanX);
			Math.Normalize(dx,dz,Movement*TheCamera.PanX);
		}
		else
		{
			// pan left
			AdjustCameraPosition(dx,dy,dz,TheCamera.XAngle,TheCamera.YAngle-90,-Movement*TheCamera.PanX);		  
			Math.Normalize(dx,dz,-Movement*TheCamera.PanX);
		}	
	
		TheCamera.At.x += dx;
		TheCamera.At.z += dz;
		TheCamera.PanX = 0;
	}
	if (TheCamera.PanY != 0)
	{
		if (TheCamera.PanY < 0)
		{
			// pan up
			AdjustCameraPosition(dx,dy,dz,TheCamera.XAngle+90,TheCamera.YAngle,-Movement*TheCamera.PanY);

		}
		else
		{
			// pan down
			AdjustCameraPosition(dx,dy,dz,TheCamera.XAngle-90,TheCamera.YAngle,Movement*TheCamera.PanY);		  
		}
		TheCamera.At.x += dx;
		TheCamera.At.z += dz; 
		TheCamera.At.y += dy;
		TheCamera.PanY = 0;
	}
	if (TheCamera.ZoomIn != 0)
	{
		if (TheCamera.ZoomIn < 0)
		{
			// zoom out
			AdjustCameraPosition(dx,dy,dz,TheCamera.XAngle,TheCamera.YAngle,Movement*15);
			TheCamera.At.x += dx;
			TheCamera.At.y += dy;
			TheCamera.At.z += dz; 
		}	   
		else 
		{
			// zoom in
			AdjustCameraPosition(dx,dy,dz,TheCamera.XAngle,TheCamera.YAngle,Movement*15);
			TheCamera.At.x -= dx;
			TheCamera.At.y -= dy;
			TheCamera.At.z -= dz; 
		}
		TheCamera.ZoomIn = 0;
	}


    TheCamera.Eye = TheCamera.At;		

	AdjustCameraPosition(dx,dy,dz,TheCamera.XAngle,TheCamera.YAngle,15);

	// adjust eye position
    TheCamera.Eye.x = TheCamera.At.x + dx;
    TheCamera.Eye.y = TheCamera.At.y + dy;
    TheCamera.Eye.z = TheCamera.At.z + dz;		
    
}

/************************************************************************
* void AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius)
*
* PURPOSE
* Main helper function for AdjustCameraPosition.  It uses 3D spheric to sove dx,dy and dz based on 2 angles
* and a radius.  Doesn't work perfectly.  Some assumptions and shortcuts were made.  Couldn't fully
* Solve the problem due to the TAN function only being accurate in 2 Quadrants out of the 4.
* USAGE
* by AdjustCameraPosition()
*************************************************************************/
void MDirectX::AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius)
{
	 // might as well mod them
    AngleX = Math.Mod360(AngleX);
    AngleY = Math.Mod360(AngleY);

	// new way
    // first resolve the y and z coordinate and then backtrack to resolve the x coordinate
    dy = Radius*(float)sin(AngleX*PI/180);
    dz = Radius*(float)cos(AngleX*PI/180);    
    
    // o.k resolve dz and dx using the old dx as the radius
    Radius = dz;
    dx = Radius*(float)sin(AngleY*PI/180);
    dz = Radius*(float)cos(AngleY*PI/180);
}

/************************************************************************
* void AdjustCameraPosition1(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius)
*
* PURPOSE
* Different way of AdjustCameraPosition using spherical equations, doesn't work as well, and is not used
* USAGE
* None, historical only
*************************************************************************/
void MDirectX::AdjustCameraPosition1(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius)
{

	// this way solves the spherical equation but it doesn't work as well, because of
	// the inherent y bais that we want
		float R1,R2;

		double Sigs = sin(AngleY*PI/180)*cos(AngleX*PI/180)/cos(AngleY*PI/180)
						*sin(AngleY*PI/180)*cos(AngleX*PI/180)/cos(AngleY*PI/180)
						+ sin(AngleX*PI/180)*sin(AngleX*PI/180)
						+ cos(AngleX*PI/180)*cos(AngleX*PI/180);
		
		R1 = Radius/(sqrt(Sigs));
		R2 = cos(AngleX*PI/180)/cos(AngleY*PI/180)*R1;

		if (R2 < 0)
			R2 = -R2;
		

		dx = sin(AngleY*PI/180)*R2;
		dz = cos(AngleY*PI/180)*R2;
		dy = sin(AngleX*PI/180)*R1;  

}

/************************************************************************
* void OnMouseMove(CPoint Point)
*
* PURPOSE
* This function changes the camera angle in Game3D camera mode
* USAGE
* By the onmove of the main window
*************************************************************************/
void MDirectX::OnMouseMove(UINT nFlags, CPoint Point)
{
	float AngleRatio = 0.3f;

	int tempo =  MK_CONTROL;
	

    if (TheCamera.PrevMousePoint.x == -1)
    {
		// don't do anything if this is the first movement (need starting point)
    }
    else if (nFlags & MK_LBUTTON) // left mouse button down, perform rotation
    {
        float DeltaX = (float)(TheCamera.PrevMousePoint.x - Point.x);
        float DeltaY = (float)(TheCamera.PrevMousePoint.y - Point.y);
                        
        TheCamera.XAngle += DeltaY*AngleRatio;
        TheCamera.YAngle += DeltaX*AngleRatio;
        
	//	TheCamera.XAngle = Math.Mod360(TheCamera.XAngle);
	//	TheCamera.YAngle = Math.Mod360(TheCamera.YAngle);

		if (TheCamera.XAngle < 0)
			TheCamera.XAngle = 0;
		if (TheCamera.XAngle > 89)
			TheCamera.XAngle = 89;
    }
	else if (nFlags & MK_RBUTTON) // right mouse button down, perform pan
    {
		TheCamera.PanX = TheCamera.PrevMousePoint.x - Point.x;
		TheCamera.PanY = TheCamera.PrevMousePoint.y - Point.y;
	}
	else if (nFlags & MK_MBUTTON) // middle mouse button, perform zoom
	{
		TheCamera.ZoomIn = TheCamera.PrevMousePoint.y - Point.y;
	}

    TheCamera.PrevMousePoint = Point;


}

/************************************************************************
* Function RCSetZoomPoint(CPoint Point
* 
* PURPOSE
* To set the center point at which to zoom
* USAGE
* Called by the window class
*************************************************************************/
void MDirectX::RCSetZoomPoint(CPoint Point)
{
	TheCamera.PrevMousePoint = Point;
}

/************************************************************************
* Function RCZoom(CPoint Point)
* 
* PURPOSE
* To Zoom in/out the view, when the mouse moves
* USAGE
* Called by the window class
*************************************************************************/
void MDirectX::RCZoom(CPoint Point)
{
	float ZoomFactor = (float)(1-(float)((Point.y-TheCamera.PrevMousePoint.y))*ZOOMPIXELPERCENT);

    TheCamera.PrevMousePoint = Point;

    TheCamera.ZoomRatio *=ZoomFactor;

}

/************************************************************************
* FunctionResetView()
*
* PURPOSE
* To Reset the view
* USAGE
* By the main view window on a reset command
*************************************************************************/
void MDirectX::RCResetView()
{
	TheCamera.Eye = D3DXVECTOR3(10,10,10);
	TheCamera.At = D3DXVECTOR3(2,2,2);
	TheCamera.Orientation = D3DXVECTOR3(0,1,0); // y is up (most of the time)

    TheCamera.MoveDown = false;
    TheCamera.MoveLeft = false;
    TheCamera.MoveRight = false;
    TheCamera.MoveUp = false;   

    TheCamera.XAngle =  89;
    TheCamera.YAngle = 0;

	TheCamera.PanX = 0;
	TheCamera.PanY = 0;
	TheCamera.ZoomIn = 0;

    
    TheCamera.ZoomRatio = 1.0f;


}

/************************************************************************
* RCSelectObject(CPoint Point)
*
* PURPOSE
* Called when the user is trying to pick an object out of the screen
*************************************************************************/
void MDirectX::RCSelectObject(CPoint Point, BOOL AddtoGroup)
{
	D3DXVECTOR3 vPickRayDir;
    D3DXVECTOR3 vPickRayOrig;

    POINT ptCursor = Point;
   // GetCursorPos( &ptCursor );
   // ScreenToClient( FramePtr->m_hWnd, &ptCursor );

    // Compute the vector of the pick ray in screen space
    D3DXVECTOR3 v;
    v.x =  ( ( ( 2.0f * ptCursor.x ) / m_d3dsdBackBuffer.Width  ) - 1 ) / TheCamera.matrixProj._11;
    v.y = -( ( ( 2.0f * ptCursor.y ) / m_d3dsdBackBuffer.Height ) - 1 ) / TheCamera.matrixProj._22;
    v.z =  1.0f;

    // Get the inverse view matrix
    D3DXMATRIX m;
    D3DXMatrixInverse( &m, NULL, &TheCamera.matrixView);

    // Transform the screen space pick ray into 3D space
    vPickRayDir.x  = v.x*m._11 + v.y*m._21 + v.z*m._31;
    vPickRayDir.y  = v.x*m._12 + v.y*m._22 + v.z*m._32;
    vPickRayDir.z  = v.x*m._13 + v.y*m._23 + v.z*m._33;
    vPickRayOrig.x = m._41;
    vPickRayOrig.y = m._42;
    vPickRayOrig.z = m._43;

	RAY theRay;

	theRay.origin = vPickRayOrig;
	theRay.direction = vPickRayDir;
	theOctTree.SelectObject(theRay,AddtoGroup);    
}
