// NewOctTree.cpp : implementation file
//

#include "stdafx.h"
#include "MapEditor.h"
#include "NewOctTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// NewOctTree dialog


NewOctTree::NewOctTree(CWnd* pParent /*=NULL*/)
	: CDialog(NewOctTree::IDD, pParent)
{
	//{{AFX_DATA_INIT(NewOctTree)
	m_DX = 4;
	m_DZ = 4;
	m_SX = 4;
	m_SY = 4;
	m_SZ = 4;
	m_EvenY = TRUE;
	m_DY = 4;
	//}}AFX_DATA_INIT
}


void NewOctTree::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(NewOctTree)
	DDX_Text(pDX, IDC_DX, m_DX);
	DDX_Text(pDX, IDC_DZ, m_DZ);
	DDX_Text(pDX, IDC_SX, m_SX);
	DDX_Text(pDX, IDC_SY, m_SY);
	DDV_MinMaxInt(pDX, m_SY, 1, 32);
	DDX_Text(pDX, IDC_SZ, m_SZ);
	DDX_Check(pDX, IDC_EVENY, m_EvenY);
	DDX_Text(pDX, IDC_DY, m_DY);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(NewOctTree, CDialog)
	//{{AFX_MSG_MAP(NewOctTree)
	ON_BN_CLICKED(IDC_EVENY, OnEveny)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// NewOctTree message handlers

void NewOctTree::OnOK() 
{
	// check if the number of segments are a factor of 2
	UpdateData();
	if (!IsBy2(m_SX))
	{
		AfxMessageBox("The X segments must be from a power of 2");
		return;
	}

	// check if the number of segments are a factor of 2
	if (!IsBy2(m_SZ))
	{
		AfxMessageBox("The Z segments must be from a power of 2");
		return;
	}

	// check if the number of segments are a factor of 2
	if (!IsBy2(m_SY))
	{
		AfxMessageBox("The Y segments must be from a power of 2");
		return;
	}
	
	CDialog::OnOK();
}

BOOL NewOctTree::IsBy2(int input)
{
	if (input == 0)
		return false;

	if (input == 1)
		return true;

	float tempo = (float)input;

	while (tempo > 1)
	{
		tempo = tempo/2;
		if ((tempo - (int)tempo) != 0)
		{
			return false;
		}
	}
	return true;
}

void NewOctTree::OnEveny() 
{
	UpdateData();
	if (m_EvenY)
	{
		CWnd *Tempo = GetDlgItem(IDC_DY);
		Tempo->ModifyStyle(0,WS_VISIBLE,0);
		Invalidate();
	}
	else
	{
		CWnd *Tempo = GetDlgItem(IDC_DY);
		Tempo->ModifyStyle(WS_VISIBLE,0,0);
		Invalidate();
	}

	
}


