// RollOut.cpp: implementation of the CRollOut class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "mapeditor.h"
#include "RollOut.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRollOut::CRollOut()
{
	// load the bitmaps
	OpenGroup.LoadBitmap(IDB_OPENGROUP);
	CloseGroup.LoadBitmap(IDB_CLOSEGROUP);

	// initialize some constants
	BitmapSize.x = 158;
	BitmapSize.y = 16;
	AddYOffset = 20;
	XOffset = (STDROWIDTH - BitmapSize.x)/2;
	YSpacingOpen = 20;
	YSpacingClosed = 10;
}

CRollOut::~CRollOut()
{
	// have to nuke the list, not the actual control in it though, just the structure
	ROLLDOWNLIST::iterator curr = GroupList.begin();
	ROLLDOWNLIST::iterator end = GroupList.end();	
	while (curr != end)
	{
		CONTROLLIST::iterator curr2 = (*curr)->ControlList.begin();
		CONTROLLIST::iterator end2 = (*curr)->ControlList.end();
		while (curr2 != end2)
		{
			delete (*curr2);
			curr2++;
		}
		delete (*curr);
		curr++;
	}

}

//=====================================================================
// OnPaint(CDC *pDC)
// 
// Usage: Psuedo message handler, called though by a scoll view class 
//	      Paints the group titles, and rectangles, nothing else
//
// Note: pDC is already doubled buffered at this point
//=====================================================================
void CRollOut::OnPaint(CDC *pDC)
{
	// load the two bitmaps (closed and open group)
	CDC OpenBitmapDC,ClosedBitmapDC;
	OpenBitmapDC.CreateCompatibleDC(pDC);
	ClosedBitmapDC.CreateCompatibleDC(pDC);

	CBitmap *pOldOpenBitmap = OpenBitmapDC.SelectObject(&OpenGroup);
	CBitmap *pOldClosedBitmap = ClosedBitmapDC.SelectObject(&CloseGroup);

	BITMAP openbitmap,closedbitmap;

	OpenGroup.GetObject(sizeof(BITMAP),&openbitmap);
	CloseGroup.GetObject(sizeof(BITMAP),&closedbitmap);

	int FontWidth = 5; // the font offset of 8 point sans serif
	int FontHeightOffset = 1;

	// set the CDC modes
	CFont *pOldFont = pDC->SelectObject(Fonts.GetFont(MSSANSSERIF));
	COLORREF  OldColor = pDC->SetBkColor(RGB(192,192,192)); // shade of gray
	int OldMode = pDC->SetBkMode(TRANSPARENT);
	
	ROLLDOWNLIST::iterator curr = GroupList.begin();
	ROLLDOWNLIST::iterator end = GroupList.end();
	while (curr != end)
	{
		// draw the open group style
		if ((*curr)->IsOpen)
		{
			// first draw the group border rectangle which consists of 2 rects of different
			// color and slightly offset
			CRect Rect3D;
			Rect3D.left = 5;
			Rect3D.right = STDROWIDTH-5;
			Rect3D.top = (*curr)->OpenSize.top+(*curr)->CurrYOffset + BitmapSize.y/2;
			Rect3D.bottom = (*curr)->OpenSize.bottom+(*curr)->CurrYOffset - YSpacingOpen/2;
			pDC->Draw3dRect(&Rect3D,RGB(110,110,110),RGB(110,110,110)); // cheap way not to have the area filled
			Rect3D.left++;
			Rect3D.right++;
			Rect3D.top++;
			Rect3D.bottom++;
			pDC->Draw3dRect(&Rect3D,RGB(225,225,225),RGB(225,225,225)); // cheap way not to have the area filled

			// blt the bitmap now
			pDC->BitBlt(XOffset,(*curr)->CurrYOffset,openbitmap.bmWidth,openbitmap.bmHeight,&OpenBitmapDC,0,0,SRCCOPY);
			// now draw the title text
			int MiddleJustifyOffset = openbitmap.bmWidth/2+XOffset - FontWidth*strlen((*curr)->Title)/2;
			pDC->TextOut(MiddleJustifyOffset,FontHeightOffset+(*curr)->CurrYOffset,(*curr)->Title);
		}
		else // draw the closed group style
		{
			// first draw the group border rectangle which consists of 2 rects of different
			// color and slightly offset
			CRect Rect3D;
			Rect3D.left = 5;
			Rect3D.right = STDROWIDTH-5;
			Rect3D.top = (*curr)->OpenSize.top+(*curr)->CurrYOffset + BitmapSize.y/3;
			Rect3D.bottom = Rect3D.top + BitmapSize.y/3 +1;
			pDC->Draw3dRect(&Rect3D,RGB(110,110,110),RGB(110,110,110)); // cheap way not to have the area filled
			Rect3D.left++;
			Rect3D.right++;
			Rect3D.top++;
			Rect3D.bottom++;
			pDC->Draw3dRect(&Rect3D,RGB(225,225,225),RGB(225,225,225)); // cheap way not to have the area filled

			// blt the bitmap now
			pDC->BitBlt(XOffset,(*curr)->CurrYOffset,closedbitmap.bmWidth,closedbitmap.bmHeight,&ClosedBitmapDC,0,0,SRCCOPY);
			// now draw the title text
			int MiddleJustifyOffset = openbitmap.bmWidth/2+XOffset - FontWidth*strlen((*curr)->Title)/2;
			pDC->TextOut(MiddleJustifyOffset,FontHeightOffset+(*curr)->CurrYOffset,(*curr)->Title);
		}
		curr++;
	}

	// clean up
	pDC->SetBkMode(OldMode);
	OpenBitmapDC.SelectObject(pOldOpenBitmap);
	ClosedBitmapDC.SelectObject(pOldClosedBitmap);
	pDC->SelectObject(pOldFont);
	pDC->SetBkColor(OldColor); 

}

//=====================================================================
// CPoint OnLButtonUp(UINT nFlags, CPoint Point)
// 
// Usage: Psuedo message handler, called though by a scoll view class 
//	      This function checks if the click is on a group header and if
//        so opens or closes the group
//
// Alogirthm:
//  1) Checks every group header until one is found if it was clicked
//  2a) If the group is now open, set all of the windows is the group based
//       on the group y offset, and the window relative offset
//       make these windows visable
//  2b) If the group is now closed, just make all of the ctrl windows in the group
//       not visible
//  3) Calculate the difference in terms of the Y offsets and propogate this downwards 
//     on the roll out list (list is in order of depth) and change the position of all group
//     headers and if any, their active control windows
//  
//  Returns:
//		The Y Offset of the group that was clicked on, so when redrawing the window, only 
//      the changed items need to be redraw.
//      Or -1 if nothing clicked on
//=====================================================================
CPoint CRollOut::OnLButtonUp(UINT nFlags, CPoint Point)
{
	CPoint InvalidateRegion;
	InvalidateRegion.x = -1;
	InvalidateRegion.y = -1;

 	ROLLDOWNLIST::iterator curr = GroupList.begin();
	ROLLDOWNLIST::iterator end = GroupList.end();	
	while (curr != end)
	{
		CRect tRect = (*curr)->OpenSize;
		tRect.bottom = tRect.top + BitmapSize.y;
		// 1) Checking if this group header is clicked on
		if (PointInRect(Point,tRect,(*curr)->CurrYOffset))
		{				
			if ((*curr)->IsOpen)
			{
				// 2b) it is open so we want it closed, calculate the YChange for below
				//     groups and make any windows in the group invisible
				int YChange = -(*curr)->OpenSize.Height()/*-YSpacingOpen*/+YSpacingClosed + BitmapSize.y;
				(*curr)->IsOpen = false;
				// now close off all of its windows
				CONTROLLIST::iterator curr2 = (*curr)->ControlList.begin();
				CONTROLLIST::iterator end2 = (*curr)->ControlList.end();
				while (curr2 != end2)
				{
					(*curr2)->theControl->ModifyStyle(WS_VISIBLE,0,0);
					curr2++;
				}		

				InvalidateRegion.y = (*curr)->CurrYOffset;

				// 3) now alter everyone elses offset below including window offset
				curr++;
				while (curr != end)
				{
					(*curr)->CurrYOffset +=YChange;
					if ((*curr)->IsOpen)
					{
						// now alter all of its windows
						curr2 = (*curr)->ControlList.begin();
						end2 = (*curr)->ControlList.end();
						while (curr2 != end2)
						{
							CRect NewRect = (*curr2)->RelativePosition;
							CPoint GetScrollOffset = ScrollViewPtr->GetCurrentScrollOffset();
							NewRect.top += (*curr)->CurrYOffset - GetScrollOffset.y;
							NewRect.bottom += (*curr)->CurrYOffset - GetScrollOffset.y;
							NewRect.left -=  GetScrollOffset.x;
							NewRect.right -=  GetScrollOffset.x;
							(*curr2)->theControl->MoveWindow(&NewRect,true);
							// redraw here?
							curr2++;
						}					
					}
					curr++;
				}
			}// end if isopen
			else
			{
				// 2a) Open up this group
				(*curr)->IsOpen = true;
				// expand the roll out
				int YChange = (*curr)->OpenSize.Height()/*+YSpacingOpen*/-YSpacingClosed - BitmapSize.y;
				// go through its windows, making them visible and giving them a new position
				CONTROLLIST::iterator curr2 = (*curr)->ControlList.begin();
				CONTROLLIST::iterator end2 = (*curr)->ControlList.end();
				while (curr2 != end2)
				{
					// first reposition the window
					CRect NewRect = (*curr2)->RelativePosition;
					CPoint GetScrollOffset = ScrollViewPtr->GetCurrentScrollOffset();
					NewRect.top += (*curr)->CurrYOffset - GetScrollOffset.y;
					NewRect.bottom += (*curr)->CurrYOffset - GetScrollOffset.y;
					NewRect.left -=  GetScrollOffset.x;
					NewRect.right -=  GetScrollOffset.x;
					(*curr2)->theControl->MoveWindow(&NewRect,true);
					// now make it visible
					(*curr2)->theControl->ModifyStyle(0,WS_VISIBLE,0);
					// redraw here?
					curr2++;
				}

				InvalidateRegion.y = (*curr)->CurrYOffset;
			
				// now go through the remaining groups adding the new offset,
				// and then repositioning them;
				curr++;
				while (curr != end)
				{
					(*curr)->CurrYOffset +=YChange;

					if ((*curr)->IsOpen)
					{
						// now alter all of its windows
						curr2 = (*curr)->ControlList.begin();
						end2 = (*curr)->ControlList.end();
						while (curr2 != end2)
						{							
							CRect NewRect = (*curr2)->RelativePosition;
							CPoint GetScrollOffset = ScrollViewPtr->GetCurrentScrollOffset();
							NewRect.top += (*curr)->CurrYOffset - GetScrollOffset.y;
							NewRect.bottom += (*curr)->CurrYOffset - GetScrollOffset.y;
							NewRect.left -=  GetScrollOffset.x;
							NewRect.right -=  GetScrollOffset.x;
							(*curr2)->theControl->MoveWindow(&NewRect,true);
							// redraw here?
							curr2++;
						}
					}
					curr++;
				}
			
			}
			// 4) Reset the scroll view height based on the maximum roll out hieght
			ScrollViewPtr->ResetVerticalSize(GetTotalHeight());
			return InvalidateRegion;
		}// end else if open
		curr++;		
	} // end look for if window selected
	return InvalidateRegion;

}

//=====================================================================
// AddGroup(char GroupTitle[], BOOL IsOpen)
// 
// Usage: Creates a new group for the roll out
//
//=====================================================================
void CRollOut::AddGroup(char GroupTitle[], BOOL IsOpen)
{
	Group *GroupPtr = new Group;

	// get the seperation information
	int SeperationOffset = 0;

	// fill in the basic values
	strcpy(GroupPtr->Title,GroupTitle);
	GroupPtr->IsOpen = IsOpen;
	GroupPtr->CurrYOffset = AddYOffset + SeperationOffset;
	GroupPtr->OpenSize.left = XOffset;
	GroupPtr->OpenSize.right = XOffset+BitmapSize.x; // bitmap width?
	GroupPtr->OpenSize.top = 0;
	if (IsOpen)
		GroupPtr->OpenSize.bottom = BitmapSize.y + YSpacingOpen;
	else
		GroupPtr->OpenSize.bottom = BitmapSize.y + YSpacingClosed;

	AddYOffset = GroupPtr->OpenSize.bottom + GroupPtr->CurrYOffset;

	// now add it to the roll out like
	GroupList.push_back(GroupPtr);
}

//=====================================================================
// AddControltoGroup(CWnd *Ctrl)
// 
// Adds a control to the last roll out group in the list
//
//=====================================================================
void CRollOut::AddControltoGroup(CWnd *Ctrl, CRect AbsoluteRect)
{
	 	
	// make sure list isn't empty
	if (GroupList.empty())
		return;

	Group *LastGroup = GroupList.back();

	// O.K all we have to do is find out its relative position and add it to the list
	CS *CSptr = new CS;
	CSptr->theControl = Ctrl;

	CRect tRect = AbsoluteRect;

	// now make tRect relative to top of group header (Y dimension only)
	tRect.top -= LastGroup->CurrYOffset;
	tRect.bottom -= LastGroup->CurrYOffset;


	CSptr->RelativePosition = tRect;
	if (LastGroup->IsOpen)
		Ctrl->ModifyStyle(0,WS_VISIBLE,0);
	else
		Ctrl->ModifyStyle(WS_VISIBLE,0,0);

	LastGroup->ControlList.push_back(CSptr);
	// don't forget to add to the group size
	int RealBottom = LastGroup->OpenSize.top + tRect.bottom + YSpacingOpen + LastGroup->CurrYOffset;
	int OpenBottom = RealBottom - LastGroup->CurrYOffset;
	if (OpenBottom > LastGroup->OpenSize.bottom)
		LastGroup->OpenSize.bottom = OpenBottom;

	if (LastGroup->IsOpen)
		AddYOffset = LastGroup->OpenSize.bottom + LastGroup->CurrYOffset;

}

//=====================================================================
// GetCurrAddYOffset();
// 
// Usage: returns the YOffset of where the top of the next item to be inserted should go.
//
//=====================================================================
int CRollOut::GetCurrAddYOffset()
{
	return AddYOffset;
}

//=====================================================================
// GetTotalHeight()
// 
// Usage: returns the total height of the roll out
//
//=====================================================================
int CRollOut::GetTotalHeight()
{
	if (GroupList.empty())
		return 0;

	ROLLDOWNLIST::iterator end = GroupList.end();	
	end--;
	int tReturn = (*end)->CurrYOffset;
	if ((*end)->IsOpen)
		tReturn += (*end)->OpenSize.Height();
	else
		tReturn += YSpacingClosed + BitmapSize.y;
	return tReturn;

}

//=====================================================================
// ResetPositions()()
// 
// Usage: Used in one function in the scroll view main class to reset everything
//         after the window has been scrolled.  Was easier to do then to fight
//         with the windows API
//
//=====================================================================
void CRollOut::ResetPositions()
{
	ROLLDOWNLIST::iterator curr = GroupList.begin();
	ROLLDOWNLIST::iterator end = GroupList.end();	
	while (curr != end)
	{						
		if ((*curr)->IsOpen)
		{
			CONTROLLIST::iterator curr2 = (*curr)->ControlList.begin();
			CONTROLLIST::iterator end2 = (*curr)->ControlList.end();
			while (curr2 != end2)
			{
				//(*curr2)->theControl->ModifyStyle(WS_VISIBLE,0,0);
				CRect NewRect = (*curr2)->RelativePosition;
				CPoint GetScrollOffset = ScrollViewPtr->GetCurrentScrollOffset();
				NewRect.top += (*curr)->CurrYOffset - GetScrollOffset.y;
				NewRect.bottom += (*curr)->CurrYOffset - GetScrollOffset.y;
				NewRect.left -=  GetScrollOffset.x;
				NewRect.right -=  GetScrollOffset.x;
				(*curr2)->theControl->MoveWindow(&NewRect,true);
				curr2++;
			}		
		}
		curr++;
	}
}
