#if !defined(AFX_SCROLLVIEW_H__A903FA4D_CFD9_4860_AFF9_D50DB636A30B__INCLUDED_)
#define AFX_SCROLLVIEW_H__A903FA4D_CFD9_4860_AFF9_D50DB636A30B__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ScrollView.h : header file

#include "StdObject.h"

class StdObject;
//

/////////////////////////////////////////////////////////////////////////////
// ScrollView window
//
// This class should be inhereted for any scroll window functionality, it should
// be used with CRollOut which handles a bit of the scrolling
//
// Note during development the horziontal scroll bar was shut off because of complications
// with the windows API
//
#define HORZSCROLLBAR 100
#define VERTSCROLLBAR 101


class ScrollView : public CWnd
{


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ScrollView)
	//}}AFX_VIRTUAL

// Implementation
private: // Variables for the scroll bars, do not touch
	// Horizontal Scroll bars variables
	CScrollBar HorizontalBar; // the scroll bar
	CRect HorzRect; // the window positioning
	int HorzPageSize; // the size of that thing inbetween the two arrows of the scroll bar
	int HorzPrevPosition; // the previous position stored
	int HorzCurrScroll; // the current offset used for bitblt the double buffer
	BOOL HorzEnabled;

	// Horizontal Scroll bars variables
	CScrollBar VerticalBar; // the scroll bar
	CRect VertRect; // the window positioning
	int VertPageSize; // the size of that thing inbetween the two arrows of the scroll bar
	int VertPrevPosition; // the previous position stored
	int VertCurrScroll; // the current offset used for bitblt the double buffer
	BOOL VertEnabled;

	int ScrollBarWidth; // width of the scroll bars

	CRect WindowSize; // the size of the window
	CRect ViewSize; // the size of the view

	// repositions/resizes the scroll bars after a change window size call occured, or on
	// initialization
	void SetScrollBars();

protected:

	StdObject *EditObjectPtr; // object that may be edited (reference to)

public:

	void ResetVerticalSize(int NewSize); // key function to reset the view based on a new view size (Y component only)
	void ReDrawBars(); // basically invalidates and updates scroll bars
	CRect GetViewSize(); // gets the view size
	CPoint GetCurrentScrollOffset(); // gets the scroll offset

	void SetEditObject(StdObject *EditObjectPtr); // called to give a value to the editobjectPtr

	CWnd *ParentPtr;
	CRect GetInvalidateRect(); // for redrawing

	// this is the function that should be used to create the scroll window
	void Create(CRect WindowSize, CPoint ViewSize, CWnd *ParentPtr);
	ScrollView();
	virtual ~ScrollView();

	// Generated message map functions
private:

	//{{AFX_MSG(ScrollView)


	//}}AFX_MSG
protected:
	virtual void Paint(CDC *pDC) {}; // this should be overridden by the inheriting class, for any neccessary painting
									 // it also provides double buffering support


	virtual void OnResetSize() {}; // called so the inherted class could adjust for changes of the window size
								   // basically used by the CRollOut class
	// message handlers handled by base (this) class
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SCROLLVIEW_H__A903FA4D_CFD9_4860_AFF9_D50DB636A30B__INCLUDED_)
