#if !defined(AFX_SPINEDITBOX_H__EE4554F6_DFF6_4E12_929F_A0A8CE057CA0__INCLUDED_)
#define AFX_SPINEDITBOX_H__EE4554F6_DFF6_4E12_929F_A0A8CE057CA0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SpinEditBox.h : header file

// Creation flags, use one of SE_FLOAT or SE_INT to specify data type 
// and one of SE_STDSPACEJUSTIFIED or SE_RIGHTJUSTIFIED tp specify how the
// window is aligned (text + editing portion)
#define SE_FLOAT 0x01
#define SE_INT	 0x02
#define SE_STDSPACEJUSTIFIED 0x04
#define SE_RIGHTJUSTIFIED 0x08

/////////////////////////////////////////////////////////////////////////////
// SpinEditBox window
// Used to house both an edit and spin window and link them together.
// Since this is so common it was desided to simply make it into a class

#define SPINCONTROLID 10
#define EDITCONTROLID 11
#define BUTTONCONTROLID 12

class SpinEditBox : public CWnd
{
// Construction
public:
	SpinEditBox();
	SpinEditBox(char *Title, CPoint Position, float Min, float Max, int Increments, UINT Flags, CWnd *Parent, int nID);
	void Create(char *Title, CPoint OffsetPosition, float Min, float Max, int Increments, UINT Flags, CWnd *Parent, int nID);


// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(SpinEditBox)
	//}}AFX_VIRTUAL

	CSpinButtonCtrl SpinButtonCtrl; // the spinner
	CEdit	Edit; // the read only edit box
	CButton ManualEdit; // the button which activates the dialog box
	CString Title; // the title of the control


// Implementation
public:

	// Window Size
	CRect WindowRect;
	CRect GetWindowRect();

	// stores the ID (many of this class could be used) to use when sending a message
	int ControlID;

	// gets the current value, if value is an int, the value will be sent through as a float
	float GetValue();

	// set member variables
	void SetValue(int Value);
	void SetValue(float Value);

	// BOOLs for special cases in the on spin function that would normally cause undesirable effects
	BOOL ManualChangeNI; // this is used to negate one manual change because if the manually edited
						 // value is not a proper interval of the spinner, the spinner appear to go
						 // down 2 intervals when selected downwards,
	BOOL ManualChange;   // Manual change special case
	BOOL PrevUp;

	// Do not send toggles the send to parent
	BOOL DoNotSend;
	void UpdateValue();	

	BOOL isFloat; // Is it a float or int type
	
	int MaxChar; // Max characters of edit box
	CString OldEditText; // obsolete
	
	CWnd *ParentPtr;
	virtual ~SpinEditBox();

	// Generated message map functions
protected:
	//{{AFX_MSG(SpinEditBox)
		afx_msg void OnSpinChanged(NMHDR* pNMHDR, LRESULT* pResult);
		afx_msg void OnManualEdit();
		afx_msg BOOL OnEraseBkgnd( CDC* pDC ) { return 1;}; // disable erasing the background
	afx_msg void OnPaint();

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:	
	float Min; // min of control
	float Max; // max of control
	int Increments; // amount of increments
	// the Current values (only one is valid)
	int CurrentValueI;
	float CurrentValueF;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SPINEDITBOX_H__EE4554F6_DFF6_4E12_929F_A0A8CE057CA0__INCLUDED_)
