// TileEditView.h: interface for the TileEditView class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TILEEDITVIEW_H__9B215AD5_14D3_4336_87E2_6591F23DA15B__INCLUDED_)
#define AFX_TILEEDITVIEW_H__9B215AD5_14D3_4336_87E2_6591F23DA15B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ScrollView.h"
#include "TileObject.h"
#include "SpinEditBox.h"
#include "RollOut.h"
#include "UButton.h"

/////////////////////////////////////////////////////////////////////////////////////
// This class is used when a tile is selected to provide a GUI to edit the tile 
//
// uses scrollwindow and CRollout
//
//

#define TILEHEIGHTCONTROL 1
#define VERTICESCONTROL 2 // next define + 4
#define GAUSSIANHEIGHTCONSTANT 6
#define GAUSSIANSIGMA 7
#define GAUSSIANENABLE 8
#define SINUSOIDALENABLE 9
#define SINUSOIDALHEIGHTCONSTANT 10
#define SINUSOIDALPERIOD 11
#define SINUSOIDALRADIUS 12
#define SINUSOIDALSELECTMODE1 13
#define SINUSOIDALSELECTMODE2 14
#define MAXCALLBACK 100

class TileEditView : public ScrollView  
{
public:

	void OnResetSize(); // overridden virtual function to call a CRollOut function

	CRollOut RollOutManager; // the roll out manager, does all of the work to do with the roll outs


	float PrevHeight;

	// an array which stores the call back functions, basically the child control sends a message
	// with an ID which is then fed into this array to produce a message handling function
	void (TileEditView::*CallbackFunctions[MAXCALLBACK])();  

	float (*TerrainFunctions[6][3])(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);

	// From the basic editing group
	void AddBasicEditing(); // adds the basic editing group
	// callbacks for the editing control
	void On_G1TileHeight();
	void On_G1VerticesChange();
	// variables,
	SpinEditBox g1_TileHeight;
	SpinEditBox g1_Vertices[4];

	// From the Gaussian editing group
	enum G3Setting {G3Local, G3Global, G3Ripple};
	G3Setting G3_Setting;
	SpinEditBox g2_HeightConstant;
	SpinEditBox g2_Sigma;
	CButton g2_Enable;
	BOOL g2_isEnabled;
	void On_G2Sigma();
	void On_G2HeightConstant();
	afx_msg void On_G2Enable();
	void AddGaussianEditing();

	// From the sinusiodal editing groiup
	void AddSinusoidalEditing();
	SpinEditBox g3_HeightConstant;
	SpinEditBox g3_Period;
	SpinEditBox g3_LDRadius;
	CButton g3_Enable;
	CComboBox g3_SelectMode1;
	CComboBox g3_SelectMode2;
	BOOL g3_isEnabled;

	void On_G3HeightConstant();
	void On_G3Period();
	void On_G3LDRadius();
	afx_msg void On_G3Enable();

	TileObject *theTilePtr; // the tile that is currently being edited;
	void Paint(CDC *pDC); // paint called by base class

	TileEditView(); // don't use this one
	TileEditView(CRect ParentOffset, CWnd *ParentPtr); // creation constructer
	void Create(CRect WindowSize, CWnd *ParentPtr); // also creates the view
	virtual ~TileEditView();

	// this message handler excepts all messages from any spineditcontrols (could be many)
	afx_msg LRESULT OnSpinEditControlMessage(WPARAM wParam, LPARAM lParam);


	// used to direct the message onto the CRollOut which is a generic window
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);


	DECLARE_MESSAGE_MAP()

};

#endif // !defined(AFX_TILEEDITVIEW_H__9B215AD5_14D3_4336_87E2_6591F23DA15B__INCLUDED_)
