// TileObject.h: interface for the TileObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TILEOBJECT_H__66C7B7BC_EB98_4611_ABDD_B8F7E6C3CCAF__INCLUDED_)
#define AFX_TILEOBJECT_H__66C7B7BC_EB98_4611_ABDD_B8F7E6C3CCAF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "UMath.h"
#include "StdObject.h"

class StdObject;

class TileObject : public StdObject
{
public:
	void ResetinOctree2();

	void ResetInOctree(); // resets the tile based on its new height

	void SetHeightD(float Height); // change the height of a tile given a delta value
	void SetHeight(float Height[4]); // change the height of a tile given all 4 height values
	void SetHeight1(float Height[4]); // change the height of a tile given all 4 height values
	// but this call doesn't adjust the neighbours height


	void GetTileHeight(float Height[4]); // returns the tile height
	void OnDeselect();
	void OnSelect();
	void CreateKnitPrevZ(TileObject *PrevZ);
	void CreateKnitPrevX(TileObject *PrevX);
	void AddGenerateBoundingSphere();

	BOOL IntersectBoundingBox(const RAY &Line, D3DXVECTOR3 &IntersectionPoint);
	BOOL IntersectBoundingSphere(const RAY &Line, D3DXVECTOR3 &IntersectionPoint);

	TileObject* Neighbours[4]; // up to 4 neighbours for each tile
						       // 4 corners for each tile
							   // 0 is +Z
							   // 1 is +X
							   // 2 is -Z
							   // 3 is -X

						
	PLANE Plane; // the plane that is used for collision detection
							// for triangle rendering maintain consistency
							//       Z  X
						 	// v1 is  0  0 
							// v2 is  1  0 
							// v3 is  1  1  
							// v4 is  0  1 

	PLANE PrevPlane; // the previous plane values used when using terrain tools

	Sphere BoundingSphere; // the sphere that is used for collision detection

	BOOL HasChange;

	TileObject();	
	TileObject(PLANE Plane); // this one should be used
	virtual ~TileObject();

};

#endif // !defined(AFX_TILEOBJECT_H__66C7B7BC_EB98_4611_ABDD_B8F7E6C3CCAF__INCLUDED_)
