// UFonts.cpp: implementation of the UFonts class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "mapeditor.h"
#include "UFonts.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

UFonts Fonts; // global reference

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

UFonts::UFonts()
{
	for (int ix = 0; ix < MAXFONTS; ix++)
	{
		Fonts[ix].isValid = false;
	}

	LOGFONT SanSerif;

	SanSerif.lfHeight = -11; 
	SanSerif.lfWidth = 0;
	SanSerif.lfEscapement = 0; 
	SanSerif.lfOrientation = 0; 
	SanSerif.lfWeight = 400; 
	SanSerif.lfItalic = 0; 
	SanSerif.lfUnderline = 0; 
	SanSerif.lfStrikeOut = 0; 
	SanSerif.lfCharSet = 0; 
	SanSerif.lfOutPrecision = 1; 
	SanSerif.lfClipPrecision = 2; 
	SanSerif.lfQuality = 1; 
	SanSerif.lfPitchAndFamily = 34; 
	sprintf(SanSerif.lfFaceName,"MS Sans Serif");

	Fonts[MSSANSSERIF].theFont.CreateFontIndirect(&SanSerif);
	Fonts[MSSANSSERIF].isValid = true;

}

UFonts::~UFonts()
{

}
//===============================================================================
//
// Usage: Returns a font specified by FontID, which should be a macro
//
// Avialable Fonts
//	0 MSSansSerif 8 point font
//===============================================================================
CFont* UFonts::GetFont(int FontID)
{
	if (Fonts[FontID].isValid)
		return &Fonts[FontID].theFont;
	else
		return NULL;
}
