// ViewManager.h: interface for the ViewManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIEWMANAGER_H__678B4F72_4931_41FE_A0E9_6B4368EA018C__INCLUDED_)
#define AFX_VIEWMANAGER_H__678B4F72_4931_41FE_A0E9_6B4368EA018C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <D3D8.h>
#include "D3DApp.h"
#include "D3DUtil.h"
#include "D3DFile.h"
#include "DXUtil.h"
#include "D3DRes.h"

#include "UMath.h"

#include "DirectXWnd.h"
#include "MDirectX.h"

#define MAXVIEWS 4

class ViewManager : public CD3DApplication 
{
public:

		CWnd *FramePtr; // ptr to the frame window, used for initialization

	void SetGridDepth(int GridDepth);
	BOOL View4;
	void OnToggle4View();
	int ToolbarOffset;
	void OnLButtonUp(UINT nFlags, CPoint Point);
	void OnLButtonDown(UINT nFlags, CPoint Point);
	void OnMButtonUp(UINT nFlags, CPoint Point);
	void OnMButtonDown(UINT nFlags, CPoint Point);
	void OnRButtonUp(UINT nFlags, CPoint Point);
	void OnRButtonDown(UINT nFlags, CPoint Point);
	void DrawRect(const RECT* pRect,DWORD color);

	int LockedView; // a view could be locked for input, this variable stores that information
	int GetView(CPoint Point);
	struct View
	{
		MDirectX Renderer;
		CRect ViewRect;
		BOOL Active;
	};

	struct VERTEX2D
	{
		D3DXVECTOR3 position; // Object space position for the vertex.
		FLOAT w;			  // Normalize w component
		DWORD color;		  // The vertex color.
	};
	enum { VERTEX_TYPE2D = D3DFVF_XYZRHW | D3DFVF_DIFFUSE};

	HRESULT Render();
	void OnRender();
	void Create();
	ViewManager();
	virtual ~ViewManager();

	int GridDepth;

	void RCResetView() {};
	void RCSelectObject(CPoint Point, BOOL AddtoGroup) {};
	void RCSetZoomPoint(CPoint Point){};
	void OnMouseMove(UINT nFlags, CPoint Point);

	DirectXWnd FrameWindow; // the display window

	CRect WindowSize;
	
	View theViews[MAXVIEWS];

};

#endif // !defined(AFX_VIEWMANAGER_H__678B4F72_4931_41FE_A0E9_6B4368EA018C__INCLUDED_)
